/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.nether_portal;

import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2826;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.nether_portal.FastBlockAccess;
import qouteall.q_misc_util.MiscHelper;

public class FrameSearching {
    public static <T> void startSearchingPortalFrameAsync(FastBlockAccess region, int regionRadius, class_2338 centerPoint, Predicate<class_2680> framePredicate, FrameSearchingFunc<T> matchShape, Consumer<T> onFound, Runnable onNotFound) {
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
            try {
                Object result = FrameSearching.searchPortalFrame(region, regionRadius, centerPoint, framePredicate, matchShape);
                MiscHelper.getServer().execute(() -> {
                    if (result != null) {
                        onFound.accept(result);
                    } else {
                        onNotFound.run();
                    }
                });
            }
            catch (Throwable oops) {
                oops.printStackTrace();
                onNotFound.run();
            }
        }, class_156.method_18349());
    }

    @Nullable
    public static <T> T searchPortalFrame(FastBlockAccess region, int regionRadius, class_2338 centerPoint, Predicate<class_2680> framePredicate, FrameSearchingFunc<T> matchShape) {
        List<class_1923> chunks = FrameSearching.getChunksFromNearToFar(region, centerPoint, regionRadius);
        int minSectionY = region.minSectionY();
        int maxSectionYExclusive = region.maxSectionYExclusive();
        return FrameSearching.searchPortalFrameWithYRange(region, framePredicate, matchShape, chunks, minSectionY, McHelper.getMinY((class_1936)region.world()), McHelper.getMaxYExclusive((class_1936)region.world()));
    }

    @Nullable
    private static <T> T searchPortalFrameWithYRange(FastBlockAccess fastBlockAccess, Predicate<class_2680> framePredicate, FrameSearchingFunc<T> matchShape, List<class_1923> chunkPoses, int minSectionY, int yRangeStart, int yRangeEnd) {
        for (class_1923 chunkPos : chunkPoses) {
            for (int cy = fastBlockAccess.minSectionY(); cy < fastBlockAccess.maxSectionYExclusive(); ++cy) {
                class_2826 chunkSection = fastBlockAccess.getSection(chunkPos.field_9181, cy, chunkPos.field_9180);
                if (chunkSection == null || chunkSection.method_38292()) continue;
                int localYStart = Math.max(0, yRangeStart - cy * 16);
                int localYEnd = Math.min(16, yRangeEnd - cy * 16);
                for (int localY = localYStart; localY < localYEnd; ++localY) {
                    for (int localZ = 0; localZ < 16; ++localZ) {
                        for (int localX = 0; localX < 16; ++localX) {
                            int worldZ;
                            int worldY;
                            int worldX;
                            T result;
                            class_2680 blockState = chunkSection.method_12254(localX, localY, localZ);
                            if (!framePredicate.test(blockState) || (result = matchShape.searchAt(fastBlockAccess, worldX = localX + chunkPos.method_8326(), worldY = localY + cy * 16, worldZ = localZ + chunkPos.method_8328())) == null) continue;
                            return result;
                        }
                    }
                }
            }
        }
        return null;
    }

    private static List<class_1923> getChunksFromNearToFar(FastBlockAccess region, class_2338 centerPoint, int regionRadius) {
        return region.chunkPoses().sorted(Comparator.comparingDouble(chunk -> chunk.method_8323().method_10262((class_2382)centerPoint))).collect(Collectors.toList());
    }

    @FunctionalInterface
    public static interface FrameSearchingFunc<T> {
        public T searchAt(FastBlockAccess var1, int var2, int var3, int var4);
    }
}

